﻿/*
 * Created by SharpDevelop.
 * User: user
 * Date: 10/02/2016
 * Time: 14:58
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.Collections.Generic;
using System.Net.Mail;
using System.Net;
using System.Text;
using WComp.Beans;
using Google.GData.Calendar;
using Google.GData.Client;
using Google.GData.Extensions;

namespace WComp.Beans
{
	/// <summary>
	/// This is a sample bean, which has an integer evented property and a method.
	/// 
	/// Notes: for beans creating threads, the IThreadCreator interface should be implemented,
	/// 	providing a cleanup method should be implemented and named `Stop()'.
	/// For proxy beans, the IProxyBean interface should  be implemented,
	/// 	providing the IsConnected property, allowing the connection status to be drawn in
	/// 	the AddIn's graphical designer.
	/// 
	/// Several classes can be defined or used by a Bean, but only the class with the
	/// [Bean] attribute will be available in WComp. Its ports will be all public methods,
	/// events and properties definied in that class.
	/// </summary>
	[Bean(Category="Manchon_Beans")]
	public class MailGoogleBean
	{
		/// <summary>
		/// Fill in private attributes here.
		/// </summary>
		private int timeSpan;
	
		/// <summary>
		/// This property will appear in bean's property panel and bean's input functions.
		/// </summary>
		public int TimeSpan {
			get { return timeSpan; }
			set {
				timeSpan = value;
				//FireIntEvent(property);		// event will be fired for every property set.
			}
		}
		
		private String recipient;
		
		public String Recipient{
			get { return recipient;}
			set {
				recipient = value;
			}
		}
		
		private String subject;
		public String Subject{
			get { return subject;}
			set {
				subject = value;
			}
		}	
		
		private String messageBody;
		public String MessageBody{
			get { return messageBody;}
			set {
				messageBody = value;
			}
		}

		/// <summary>
		/// A method sending an event, which is here simply the argument + 1.
		/// Note that there is no return type to the method, because we use events to send
		/// information in WComp. Return values don't have to be used.
		/// </summary>
		public void checkTimeSpanToEvent(bool status)
		{
			String appName = "ManchonEvents";
			String userName = "smartmanchon@gmail.com";
			String password = "smartmanchonocs";
			List<EventEntry> listEvents = new List<EventEntry>();
			CalendarService service = new CalendarService(appName);
			service.setUserCredentials(userName,password);
			// Create the query object:
			EventQuery query = new EventQuery();
			query.Uri = new Uri("http://www.google.com/calendar/feeds/" + 
				service.Credentials.Username + "/private/full");
		    query.StartTime = new DateTime(2016, 1, 1);
		    query.EndTime = DateTime.Now;
		    query.ExtraParameters = "orderby=starttime&sortorder=ascending";

			// Tell the service to query:
			EventFeed calFeed = service.Query(query);
			float totalMinutes = 0;
			DateTime dt2 = DateTime.Now;
			FireIntEvent(calFeed.Entries.Count);
			foreach(EventEntry feedEntry in calFeed.Entries){
				totalMinutes = (float)((TimeSpan)(feedEntry.Times[0].StartTime - dt2)).TotalMinutes;
				//FireIntEvent(totalMinutes);
				if(totalMinutes <= timeSpan){
					ShowerToCloseToNextEvent(true);
				}
				else{
					ShowerToCloseToNextEvent(false);
				}
			}
		} 
		
		public void sendMail(){
			timeSpan++;
			SmtpClient client = new SmtpClient();
		    client.Host = "smtp.googlemail.com";
		    client.Port = 587;
		    client.UseDefaultCredentials = false;
		    client.DeliveryMethod = SmtpDeliveryMethod.Network;
		    client.EnableSsl = true;
		    client.Credentials = new NetworkCredential("smartmanchon@gmail.com", "smartmanchonocs");
		    MailMessage mail = new MailMessage("smartmanchon@gmail.com", recipient, subject, messageBody);
			mail.BodyEncoding = UTF8Encoding.UTF8;
			mail.DeliveryNotificationOptions = DeliveryNotificationOptions.OnFailure;
		    client.Send(mail); 
		}

		/// <summary>
		/// Here are the delegate and his event.
		/// A function checking nullity should be used to fire events (like FireIntEvent).
		/// </summary>
		public delegate void IntValueEventHandler(int val);
		/// <summary>
		/// the following declaration is the event by itself. Its name, here "PropertyChanged",
		/// is the name of the event as it will be displayed in the bean type's interface.
		/// </summary>
		public event IntValueEventHandler PropertyChanged;
		
		private void FireIntEvent(int i) {
			if (PropertyChanged != null)
				PropertyChanged(i);
		}
		
		
		public delegate void StartedShowerHandler();
		public event StartedShowerHandler StartedShower;
		private void StartedShowerEvent(){
			this.StartedShower();
		}
		
		public delegate void StopShower(Boolean val);
		public event StopShower ShowerTime;
		private void ShowerToCloseToNextEvent(Boolean state){
			if(ShowerTime != null){
				this.ShowerTime(state);
			}
		}
	}
}
